<?php
/*--------------------------------------------------------------------
 Repository.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitWeight\Database\Repository;

use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\CombisIdDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\DTO\WeightDto;
use Gambio\Shop\Properties\SellingUnitWeight\Database\Repository\Readers\ReaderInterface;

/**
 * Class Repository
 * @package Gambio\Shop\Properties\SellingUnitWeight\Database\Repository
 */
class Repository implements RepositoryInterface
{
    /**
     * @var ReaderInterface
     */
    protected $reader;
    
    
    /**
     * Repository constructor.
     *
     * @param ReaderInterface $reader
     */
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function combinationWeight(CombisIdDto $dto): WeightDto
    {
        return $this->reader->combinationWeight($dto);
    }
}